/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;

import djbuch.kapitel_06.GC;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

/**
 * @author Thomas Ekert
 *
 */
public class DJStressRunnerOneSession {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null; //"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null; //"Thomas Ekert/DJBUCH";	//null fr lokale Session

	private static final int STRESS_COUNT=100; //Anzahl der gleichzeitigen Tests
	private static final int DELAY = 100;      //Wartezeit in Millisekunden zwischen zwei Pfrfroutinen
	private static final int MAX_DELAY=50000;  //Maximallaufzeit in Millisekunden
	
	
	private static final int MAX_DELAY_COUNT = MAX_DELAY/DELAY;
	private static final boolean [] info = new boolean [STRESS_COUNT];
	private static DJStressTestExternalSession [] st = new DJStressTestExternalSession [STRESS_COUNT];
	private static NotesThread [] nt = new NotesThread [STRESS_COUNT];
	
	public static void main(String[] args){
		Session session = null;
		try {
			if (HOST == null) {
				NotesThread.sinitThread();
			}
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			long L = System.currentTimeMillis();
			// Alle Threads starten
			for (int i=0; i < STRESS_COUNT; i++) {
				st [i] = new DJStressTestExternalSession (session,"Thread " + i);
				nt [i] = new NotesThread( st [i]);
				nt [i].start();
				info[i] = false;
			}
			//auf alle Ergebnisse warten
			int allDone=0;
			for (int dCount = 0; dCount < MAX_DELAY_COUNT && allDone!=STRESS_COUNT; dCount++) {
				int tmpDone = allDone;
				for (int i = 0; i < STRESS_COUNT; i++) {
					if (st [i].isDone() && !info [i]) {
						//System.out.println ("Thread " + i + " is done.");
						allDone++;
						info [i] = true;
					}
				}
				if (tmpDone != allDone) {
					System.out.println (allDone + " Threads done. (" + (System.currentTimeMillis() - L) + ")");
				}
				Thread.sleep(DELAY);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			//berfallige Threads stoppen
			for (int i = 0; i < STRESS_COUNT; i++) {
				if (!st [i].isDone()) {
					System.out.println ("Stopping Thread " + i);
					nt[i].stop();
				}
			}
			GC.recycle (session);
			if (HOST == null) {
				NotesThread.stermThread();
			}
		}
	}
	private DJStressRunnerOneSession () {
		
	}
}
